/*
 * Decompiled with CFR 0.152.
 */
package the_horde;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Io {
    private ByteBuffer _intShifter = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);

    public boolean PathExists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public String getExeLoc() throws URISyntaxException {
        return System.getProperty("user.dir");
    }

    public String PathCombine(String p1, String p2) {
        return Paths.get(p1, p2).toString();
    }

    public String FileReadAllText(String path) throws IOException {
        System.out.println(path);
        return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
    }

    public byte[] FileReadAllBytes(String path) throws IOException {
        return Files.readAllBytes(Paths.get(path, new String[0]));
    }

    public void FileWriteAllByte(String path, byte[] bytes) throws IOException {
        Files.write(Paths.get(path, new String[0]), bytes, new OpenOption[0]);
    }

    public void deleteFile(String path) {
        try {
            Files.delete(Paths.get(path, new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> getFiles(String path, String searchPattern) {
        File[] listOfFiles = new File(path).listFiles();
        ArrayList<String> fileArrStr = new ArrayList<String>();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile() || !Pattern.matches(searchPattern, listOfFiles[i].getName())) continue;
            fileArrStr.add(listOfFiles[i].getAbsolutePath());
        }
        return fileArrStr;
    }

    public String getFileNameWithoutExtension(String str) {
        str = new File(str).getName();
        String fileName = "";
        if (str != null) {
            int pos = str.lastIndexOf(".");
            if (pos == -1) {
                return str;
            }
            fileName = str.substring(0, pos);
        }
        return fileName;
    }

    public byte[] intToByte(int value) {
        this._intShifter.clear();
        this._intShifter.putInt(value);
        return this._intShifter.array();
    }

    public byte[] shortToByte(short value) {
        this._intShifter.clear();
        this._intShifter.putInt(value);
        return this._intShifter.array();
    }

    public int byteToInt32(byte[] data, int offset) {
        return this.byteToInt(data, offset, 32);
    }

    public short byteToInt16(byte[] data, int offset) {
        this._intShifter.clear();
        this._intShifter.put(data, offset, 2);
        this._intShifter.flip();
        return this._intShifter.getShort();
    }

    public int byteToInt(byte[] data, int offset, int size) {
        this._intShifter.clear();
        this._intShifter.put(data, offset, size / 8);
        this._intShifter.flip();
        return this._intShifter.getInt();
    }

    public String getStrFromByteArrASCII(byte[] bArr, int start, int length) {
        return new String(bArr, start, length, StandardCharsets.UTF_8).replace('\u0000', ' ').trim();
    }
}

